/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.settlement;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.ai.msg.Telegram;
import com.badlogic.gdx.ai.msg.Telegraph;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import technology.rocketjump.undermount.assets.model.GameMaterial;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.physical.item.ItemEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.item.ItemType;
import technology.rocketjump.undermount.gamecontext.GameContext;
import technology.rocketjump.undermount.gamecontext.GameContextAware;
import technology.rocketjump.undermount.gamecontext.Updatable;
import technology.rocketjump.undermount.messaging.types.ItemDestroyedMessage;
import technology.rocketjump.undermount.rendering.DebugWindow;
import technology.rocketjump.undermount.rooms.ItemAllocation;
import technology.rocketjump.undermount.rooms.Room;

@Singleton
public class ItemTracker
implements GameContextAware,
Updatable,
Telegraph {
    private final MessageDispatcher messageDispatcher;
    private final DebugWindow debugWindow;
    private GameContext gameContext;
    private final Map<ItemType, Map<GameMaterial, Map<Long, Entity>>> itemTypesToMaterialsMap = new HashMap<ItemType, Map<GameMaterial, Map<Long, Entity>>>();

    @Inject
    public ItemTracker(MessageDispatcher messageDispatcher, DebugWindow debugWindow) {
        this.messageDispatcher = messageDispatcher;
        this.debugWindow = debugWindow;
        messageDispatcher.addListener(this, 700);
        messageDispatcher.addListener(this, 702);
        messageDispatcher.addListener(this, 701);
    }

    public Set<GameMaterial> getMaterialsByItemType(ItemType itemType) {
        Map<GameMaterial, Map<Long, Entity>> materialMap = this.itemTypesToMaterialsMap.get(itemType);
        if (materialMap != null) {
            return materialMap.keySet();
        }
        return null;
    }

    @Override
    public boolean handleMessage(Telegram msg) {
        switch (msg.message) {
            case 700: {
                Entity newItemEntity = (Entity)msg.extraInfo;
                this.gameContext.getEntityStore().add(newItemEntity, this.gameContext.getAreaMap());
                this.addItem(newItemEntity);
                return true;
            }
            case 702: {
                ItemDestroyedMessage message = (ItemDestroyedMessage)msg.extraInfo;
                ItemEntityAttributes attributes = message.getAttributes();
                this.itemTypesToMaterialsMap.get(attributes.getItemType()).get(attributes.getMaterial(attributes.getItemType().getPrimaryMaterialType())).remove(message.getEntityId());
                return true;
            }
            case 701: {
                ItemAllocation allocation = (ItemAllocation)msg.extraInfo;
                if (allocation.getTargetType().equals((Object)ItemAllocation.AllocationTargetType.ROOM)) {
                    Entity itemEntity;
                    Room targetRoom = this.gameContext.getAreaMap().getRoom(allocation.getTargetId());
                    if (targetRoom != null && targetRoom.getStockpileComponent() != null) {
                        targetRoom.getStockpileComponent().allocationCancelled(allocation);
                    }
                    if ((itemEntity = this.gameContext.getEntityStore().getById(allocation.getItemEntityId())) != null) {
                        ItemEntityAttributes attributes = (ItemEntityAttributes)itemEntity.getPhysicalEntityComponent().getAttributes();
                        attributes.setNumAllocated(attributes.getNumAllocated() - allocation.getQuantity());
                    }
                    return true;
                }
                return false;
            }
        }
        throw new IllegalArgumentException("Unexpected message type " + msg.message + " received by " + this.toString() + ", " + msg.toString());
    }

    private void addItem(Entity entity) {
        Map<GameMaterial, Map<Long, Entity>> materialsToEntities;
        ItemEntityAttributes attributes = (ItemEntityAttributes)entity.getPhysicalEntityComponent().getAttributes();
        ItemType itemType = attributes.getItemType();
        GameMaterial material = attributes.getMaterial(itemType.getPrimaryMaterialType());
        if (!this.itemTypesToMaterialsMap.containsKey(itemType)) {
            this.itemTypesToMaterialsMap.put(itemType, new HashMap());
        }
        if (!(materialsToEntities = this.itemTypesToMaterialsMap.get(itemType)).containsKey(material)) {
            materialsToEntities.put(material, new ConcurrentHashMap());
        }
        Map<Long, Entity> entityMap = materialsToEntities.get(material);
        entityMap.put(entity.getId(), entity);
    }

    public List<Entity> getItemsByType(ItemType itemType, boolean unallocatedOnly) {
        ArrayList<Entity> found = new ArrayList<Entity>();
        Map<GameMaterial, Map<Long, Entity>> materialMap = this.itemTypesToMaterialsMap.get(itemType);
        if (materialMap != null) {
            for (Map<Long, Entity> entityLongMap : materialMap.values()) {
                for (Entity entity : entityLongMap.values()) {
                    if (unallocatedOnly) {
                        ItemEntityAttributes attributes = (ItemEntityAttributes)entity.getPhysicalEntityComponent().getAttributes();
                        if (attributes.getNumUnallocated() <= 0) continue;
                        found.add(entity);
                        continue;
                    }
                    found.add(entity);
                }
            }
        }
        return found;
    }

    public Iterable<Entity> getItemsByTypeAndMaterial(ItemType itemType, GameMaterial gameMaterial) {
        Map<GameMaterial, Map<Long, Entity>> materialMap = this.itemTypesToMaterialsMap.get(itemType);
        if (materialMap == null) {
            return null;
        }
        Map<Long, Entity> entries = materialMap.get(gameMaterial);
        if (entries == null) {
            return null;
        }
        return entries.values();
    }

    @Override
    public void update(float deltaTime) {
        for (Map.Entry<ItemType, Map<GameMaterial, Map<Long, Entity>>> itemTypeMapEntry : this.itemTypesToMaterialsMap.entrySet()) {
            ItemType itemType = itemTypeMapEntry.getKey();
            for (Map.Entry<GameMaterial, Map<Long, Entity>> gameMaterialLongMapEntry : itemTypeMapEntry.getValue().entrySet()) {
                GameMaterial material = gameMaterialLongMapEntry.getKey();
                Map<Long, Entity> entities = gameMaterialLongMapEntry.getValue();
                int quantity = 0;
                for (Entity entity : entities.values()) {
                    ItemEntityAttributes attributes = (ItemEntityAttributes)entity.getPhysicalEntityComponent().getAttributes();
                    quantity += attributes.getQuantity();
                }
            }
        }
    }

    @Override
    public boolean runWhilePaused() {
        return true;
    }

    @Override
    public void onContextChange(GameContext gameContext) {
        this.itemTypesToMaterialsMap.clear();
        this.gameContext = gameContext;
    }
}

